public class Tablica<T> {
  private T tab[];
  Tablica(int size){
    tab = (T[]) new Object[size];
  }
  public T get(int index){
    if(index >= tab.length || index < 0){
      throw new ArrayIndexOutOfBoundsException("index = " + index);
    }
    else{
      return (T) tab[index];
    }
  }
  public void set(int index, T value){
    if(index < 0){
      throw new ArrayIndexOutOfBoundsException("index = " + index);
    }
    if(index >= tab.length){
      resize(index + 1);
    }
    tab[index] = value;
  }
  protected void resize(int size){
    T newTab[] = (T[]) new Object[size];
    for(int i = 0; i < tab.length; i++){
      newTab[i] = tab[i];
    }
    tab = newTab;
  }
  public int size(){
    return tab.length;
  }

  public static void main(String args[]){
    Tablica<Integer> tab = new Tablica<Integer>(2);
    tab.set(0, 1);
    tab.set(1, 2);
    //źle, Object to nie Integer
    //tab.set(2, new Object());
    for(int i = 0; i < tab.size(); i++){
      System.out.println("tab[" + i + "] = " + tab.get(i) + " ");
    }
    tab.get(3);
  }
}
